//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide a view to see a url.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-18-94	created
#include"turlview.h"
#include"trace.h"

void TURLView::shutDown()	{
//	Purpose:	Provide TurboVision with a way to correctly destroy
//			a TURLView object.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-18-94	created since TurboVision seemingly won't
//				call the destrutor of this class when leaving
//				the application.

#ifndef RELEASE
	trace("Entering TURLView::shutDown.");
#endif // RELEASE

	//	Close the temporary file.
	if(fsp_temp != NULL)	{
#ifndef RELEASE
		trace("Closing temporary file.");
#endif // RELEASE
		fsp_temp->close();
		delete(fsp_temp);
	}

	//	Delete the temporary file name and the temporary file.
	if(TTNp_temp != NULL)	{
#ifndef RELEASE
		trace("Removing temporary name, possibly file.");
#endif // RELEASE
		delete(TTNp_temp);
		TTNp_temp = NULL;
	}

	//	Call the base shutdown.
#ifndef RELEASE
	trace("Calling TScroller::shutDown().");
#endif // RELEASE
	TScroller::shutDown();
}