//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide a view for any URL.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		04-07-94	created
#define Uses_TDialog
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TButton
#define Uses_TProgram
#define Uses_TDeskTop
#include"turlview.h"
#include"globals.h"
#include<string.h>

void TURLView::addToHotList()	{
//	Purpose:	Add the currently displayed view to the hotlist file.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		If the hotlistfile is not specified, nothing will happen.
//		If the hotlistfile does not exist, an attempt to create one
//			will be made.
//		If the hotlistfile exists, the current view's URL will be
//			appended to it.
//	Revision History:
//		04-07-94	created

	//	See if we have a hotlist file.
	if(::cp_HotList == NULL)	{
		doslynxmessage("hotlistfile not specified in the "
			"configuration file.");
		return;
	}

	//	Attempt to open to append.
	auto fstream *fsp_hotlist = new fstream(cp_HotList, ios::out |
		ios::app);
	if(fsp_hotlist == NULL)	{
		doslynxmessage("Unable to open hotlistfile specified in "
			"the configuration file.");
		return;
	}

	//	Get the user's name for the anchor to add to the hotlist.
	//	General use rectangle.
	auto TRect TR(0, 0, 50, 7);

	//	Create a dialog that asks for the title.
	TDialog *TDp_title = new TDialog(TR, "Add to Hotlist");
	if(TDp_title == NULL)	{
		doslynxmessage("Unable to create title dialog.");
		return;
	}

	//	Set some dialog options.
	TDp_title->options |= ofCentered;

	//      Make the input line to enter the title.
	TR = TRect(6, 2, 44, 3);
	TInputLine *TILp_title = new TInputLine(TR, usi_TILURLSize - 1);
	if(getTitle() != NULL)	{
		TILp_title->setData((void *)getTitle());
	}
	TDp_title->insert(TILp_title);


	//	Make the input line's label.
	TR = TRect(5, 1, 44, 2);
	TLabel *TLp_prompt = new TLabel(TR, "~E~nter a name to remember "
		"the URL by", TILp_title);
	TDp_title->insert(TLp_prompt);

	//	Insert the Ok and Cancel buttons.
	auto TButton *TBp_button;
	TR = TRect(9, 4, 21, 6);
	TBp_button = new TButton(TR, "~O~K", cmOK, bfDefault);
	TDp_title->insert(TBp_button);
	TR = TRect(24, 4, 36, 6);
	TBp_button = new TButton(TR, "~C~ancel", cmCancel, bfNormal);
	TDp_title->insert(TBp_button);

	//	Stay in the device name field.
	TDp_title->selectNext(False);

	//	Draw the dialog.
	TDp_title->drawView();

	//	Execute the dialog.
	if(TProgram::deskTop->execView(TDp_title) != cmCancel)	{
		//	User didn't cancel, save what we got as the device
		//	name.
		auto char ca_buffer[usi_TILURLSize];
		TILp_title->getData(ca_buffer);

		//	Output a new line in the hotlist file.
		fsp_hotlist->write("\n<BR>\n", 6);

		//	Write out the anchor.
		fsp_hotlist->write("<A HREF=\"", 9);
		fsp_hotlist->write(getURL(), strlen(getURL()));
		fsp_hotlist->write("\">", 2);
		fsp_hotlist->write(ca_buffer, strlen(ca_buffer));
		fsp_hotlist->write("</A>", 4);


		//	Give a message telling the user that the change
		//	may not be immediate.
		doslynxmessage("If the Hot List is being viewed or has been "
			"recently");
		doslynxmessage("you may have to exit DosLynx before changes "
			"take effect.");
	}

	//	Done with dialog.
	destroy(TDp_title);

	//	Done with the file.
	fsp_hotlist->close();
	delete(fsp_hotlist);
}